// Generated by CoffeeScript 1.7.1
(function() {
  var EventEmitter, ipc,
    __slice = [].slice;

  EventEmitter = require('events').EventEmitter;

  ipc = require('ipc');

  module.exports.wrap = function(webContents) {
    if (!webContents.isAlive()) {
      return null;
    }
    webContents.__proto__ = EventEmitter.prototype;
    webContents.send = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return this._send('ATOM_INTERNAL_MESSAGE', __slice.call(args));
    };
    webContents.loaded = false;
    webContents.once('did-finish-load', function() {
      return this.loaded = true;
    });
    webContents.executeJavaScript = function(code) {
      if (this.loaded) {
        return this._executeJavaScript(code);
      } else {
        return webContents.once('did-finish-load', this._executeJavaScript.bind(this, code));
      }
    };
    webContents.getId = function() {
      return "" + (this.getProcessId()) + "-" + (this.getRoutingId());
    };
    webContents.equal = function(other) {
      return this.getId() === other.getId();
    };
    webContents.on('render-view-deleted', function(event, processId, routingId) {
      return process.emit('ATOM_BROWSER_RELEASE_RENDER_VIEW', "" + processId + "-" + routingId);
    });
    webContents.on('ipc-message', (function(_this) {
      return function() {
        var args, channel, event;
        event = arguments[0], channel = arguments[1], args = 3 <= arguments.length ? __slice.call(arguments, 2) : [];
        Object.defineProperty(event, 'sender', {
          value: webContents
        });
        return ipc.emit.apply(ipc, [channel, event].concat(__slice.call(args)));
      };
    })(this));
    webContents.on('ipc-message-sync', (function(_this) {
      return function() {
        var args, channel, event;
        event = arguments[0], channel = arguments[1], args = 3 <= arguments.length ? __slice.call(arguments, 2) : [];
        Object.defineProperty(event, 'returnValue', {
          set: function(value) {
            return event.sendReply(JSON.stringify(value));
          }
        });
        Object.defineProperty(event, 'sender', {
          value: webContents
        });
        return ipc.emit.apply(ipc, [channel, event].concat(__slice.call(args)));
      };
    })(this));
    return webContents;
  };

}).call(this);
